#include "GABA.h"


template <typename T>
void GABA<T>::DoOneStepPart2(int iter)
{
    // Update GTonicGABA
    #pragma omp barrier
    #pragma omp master
    {
        if (dynamicGTonicGABA)
        {
            // Call DoOneStepPart2_FirstModel or DoOneStepPart2_SecondModel
            (this->*DoOneStepPart2_)(iter);
        }
    }
    #pragma omp barrier
}


template <typename T>
void GABA<T>::DoOneStepPart2_FirstModel(int iter)
{
    using namespace DistEnv;

    T GTonic_der = GTonic_rhp();
    GTonicGABA = GTonicGABA_old + dt * GTonic_der;
    if (watchGTonicGABA && myRank == MASTER_RANK)
    {
        GTonicGABA_vec[iter + 1] = GTonicGABA;
    }
}


template <typename T>
void GABA<T>::DoOneStepPart2_SecondModel(int iter)
{
    using namespace DistEnv;

    T GABA_der = GABA_rhp();
    GABA_ = GABA_old + dt * GABA_der;
    GTonicGABA = GABAToGTonicForSecondModel(GABA_);
    if (watchGTonicGABA && myRank == MASTER_RANK)
    {
        GTonicGABA_vec[iter + 1] = GTonicGABA;
    }
}
