#include "MatFileIOUtils.h"
#include "GetTypeTagUtils.h"
#include "Containers/LocalVector.h"
#include "Containers/LocalDenseMatrix.h"
#include "Containers/LocalSparseMatrix.h"
#include "DistEnv.h"

#include <stdio.h>  // printf
#include <stdint.h> // uint8_t, uint64_t
#include <mpi.h>

#include <iostream> // cout, flush

using namespace std;


namespace pMat
{
    MATFile *pInMatFile;
    MATFile *pImageMatFile;
    MATFile *pIntermMatFile;
    MATFile *pOutMatFile;

    // Relative paths to input/output/intermediate/backup MAT-files.
    // Remark:
    // Usage of slash "/" instead of backslash "\" below looks odd for Windows,
    // but it's actually correct multiplatform code. (Linux supports only slash while Windows supports both.)
    const char *inMatFile = "./iofiles/host-kernel/input.mat\0";
    const char *imageMatFile = "./iofiles/host-kernel/image.mat\0";
    const char *intermMatFile = "./iofiles/kernel-kernel/intermediate.mat\0";
    const char *outMatFile = "./iofiles/kernel-host/output.mat\0";
    const char *backupIntermMatFile1 = "./iofiles/backup/backup-1/kernel-kernel/intermediate.mat\0";
    const char *backupOutMatFile1 = "./iofiles/backup/backup-1/kernel-host/output.mat\0";
    const char *backupIntermMatFile2 = "./iofiles/backup/backup-2/kernel-kernel/intermediate.mat\0";
    const char *backupOutMatFile2 = "./iofiles/backup/backup-2/kernel-host/output.mat\0";
    const char *snapshotOutMatFile = "./iofiles/kernel-host/snapshot/output.mat\0";
}


// TODO: Call mxDestroyArray(aPtr) for scalars and arrays

#include "MatFileReadUtils.cpp"
#include "MatFileWriteUtils.cpp"
