#pragma once

#include "Containers/DistVector.h"
#include "SCMs/SimpleSCM.h"
#include "SCMs/SparseSCM.h"

#include <mat.h>    // MATFile


// The enum specifying the MAT file to read from or write to
enum MatFile
{
    Input,          // "input.mat"
    Image,          // "image.mat"
    Intermediate,   // "intermediate.mat"
    IntermInput,    // "intermediate.mat" or "input.mat" if the former is absent
    Output          // "output.mat"
};

namespace pMat
{
    extern MATFile *pInMatFile;
    extern MATFile *pImageMatFile;
    extern MATFile *pIntermMatFile;
    extern MATFile *pOutMatFile;

    extern const char *inMatFile;
    extern const char *imageMatFile;
    extern const char *intermMatFile;
    extern const char *outMatFile;
    extern const char *backupIntermMatFile1;
    extern const char *backupOutMatFile1;
    extern const char *backupIntermMatFile2;
    extern const char *backupOutMatFile2;
    extern const char *snapshotOutMatFile;
}

#include "MatFileReadUtils.h"
#include "MatFileWriteUtils.h"
