#include "ModCurrent.h"

// Each CPP-file below contains partial implementation of ModCurrent class
#include "MCurReadAllocateWrite.cpp"
#include "MCurDoOneStepPart1.cpp"
#include "MCurDoOneStepPart2.cpp"

// Custom constructor
template <typename T, typename RNGT>
ModCurrent<T, RNGT>::ModCurrent(char suffix, T dt, bool continuationMode, bool enable, int num, int m_steps_prev, int m_steps)
{
    assert(suffix == 'e' || suffix == 'i');

    switch (suffix)
    {
        case 'e':
            p_AllModCurrents = std::make_shared<AllModCurrents_e<T>>(num, continuationMode);
            break;
        case 'i':
            p_AllModCurrents = std::make_shared<AllModCurrents_i<T>>(num, continuationMode);
            break;
    }

    this->suffix = suffix;

    this->dt = dt;
    this->dt05 = dt / 2;

    this->m_steps_prev = m_steps_prev;
    this->m_steps = m_steps;

    ReadInputDataAllocateTemporaryArrays(continuationMode, enable);
}

template
class ModCurrent<float, std::mt19937>;

template
class ModCurrent<double, std::mt19937>;

template
class ModCurrent<double, std::mt19937_64>;
