#pragma once

#include "Containers/DistVector.h"
#include "MatFileIO/MatFileIOUtils.h"

#include "Autogenerated/AllModCurrents.h"

template <typename T, typename RNGT>
class ModCurrent
{

public:
    // The current itself
    DistVector<T> I;

public:

    // Constructors

    ModCurrent() = default;

    ModCurrent(char suffix, T dt, bool continuationMode, bool enable, int num, int m_steps_prev, int m_steps);

public:

    std::shared_ptr<AllModCurrentsBase<T>> p_AllModCurrents;

    // Public methods

    void GatherWriteIntermediateData();
    void WriteOutputData(int num_steps);

    void DoOneStepPart1(const DistVector<T> &v);
    void DoOneStepPart2(int iter, const DistVector<T> &v, const DistVector<T> &v_tmp);

private:
    void ReadInputDataAllocateTemporaryArrays(bool continuationMode, bool enable);
    void ReadTransitMxArrays();
    void WriteTransitMxArrays();

private:
    // "e" or "i"
    std::string suffix;

    // Time steps
    T dt, dt05;

    // Numbers of steps in the previous session and this session
    int m_steps_prev, m_steps;

    // Parameters for visualization
    int watchedModCurrentNum;
    LocalVector<int> watchedModCurrentIdx;
    LocalDenseMatrix<T, RNGT> watchedModCurrentI;

    // Input MAT file verbatims
    mxArray *watchedModCurrentIdxOneBased;

};
