#include "VoltageClamp.h"

// The CPP-file below contains partial implementation of VoltageClamp class
#include "VoltageClampReadAllocateWrite.cpp"


// Capacitance: I = Cm * dV/dt
template <typename T>
const T VoltageClamp<T>::Cm = 1;    // It is equal 1 "by definition"


// Custom constructor (called on all ranks with single thread)
template <typename T>
VoltageClamp<T>::VoltageClamp(char suffix, bool continuationMode, bool applyClamp, int numCells, int m_steps_prev, int m_steps)
{
    assert(suffix == 'e' || suffix == 'i');

    this->applyClamp = applyClamp;

    if (applyClamp)
    {
        ReadInputDataAllocateTemporaryArrays(suffix, continuationMode, numCells, m_steps_prev, m_steps);
    }
}


// The main method: get voltage derivative, apply clamp, save current
// (called on all ranks with multiple threads)
template <typename T>
T VoltageClamp<T>::GetVoltageDer(T current, int cellLocalIdx, bool saveCurrent, int iter)
{
    if (!applyClamp)
    {
        // Do not clamp voltage, do not watch current
        return current / Cm;
    }

    if (saveCurrent)
    {
        watched_ccv.CopyValueToVector(current, this->clampedWatchedCellRank, this->clampedWatchedCellLocalIdxOrMinus1, iter, cellLocalIdx);
    }

    if (cellLocalIdx == this->clampedWatchedCellLocalIdxOrMinus1)
    {
        // Clamp voltage
        return 0;
    }
    else
    {
        // Do not clamp voltage
        return current / Cm;
    }
}


template
class VoltageClamp<float>;

template
class VoltageClamp<double>;
