#pragma once

#include "Containers/LocalVector.h"

// This class is responsible for applying voltage clamp to a cell and watching current in it.
// Also, it calculates the voltage derivative based on the current.
template <typename T>
class VoltageClamp
{

public:
    // Constructors (the second one is called on all ranks with single thread)
    VoltageClamp() = default;
    VoltageClamp(char suffix, bool continuationMode, bool applyClamp, int numCells, int m_steps_prev, int m_steps);

    // The main method: get voltage derivative, apply clamp, save current
    // (called on all ranks with multiple threads)
    T GetVoltageDer(T current, int cellLocalIdx, bool saveCurrent, int iter);

    // Public I/O staff (called on master rank with single thread)
    void WriteOutputData(int num_steps);

private:

    // Private I/O staff (called from ctor)
    void ReadInputDataAllocateTemporaryArrays(char suffix, bool continuationMode, int numCells, int m_steps_prev, int m_steps);

    // Capacitance: I = Cm * dV/dt
    static const T Cm;

    // Names of variables in MAT-file (with "e" or "i" suffix)
    std::string clampedWatchedCellIdxParamName;
    std::string watchedCurrentParamName;

    // Whether to apply the voltage clamp and watch the current
    bool applyClamp;

    // The clamped/watched cell rank
    int clampedWatchedCellRank;

    // The clamped/watched cell local index or -1 if this rank does not correspond to the cell
    int clampedWatchedCellLocalIdxOrMinus1;

    // Container for watched data (Current at Clamped Voltage)
    LocalVector<T> watched_ccv;

    // The clamped/watched cell index, 1-based (input MAT file verbatim)
    mxArray *clampedWatchedCellIdxVerbatim;
};