@echo off

rem Build HPC kernel in Release configuration.

rem On the exit, the error level indicates the build success.
rem Calling this BAT-script without any arguments makes it pause at the end.

call vars.bat

set "MPIDIR=C:\Program Files (x86)\Microsoft SDKs\MPI"

set MPIINCLDIR="%MPIDIR%\Include"
set MPILIBDIR="%MPIDIR%\Lib\x64"
set TARGETNAME=gs

del %TARGETNAME%.* > NUL

echo on

cl /openmp /O2 /Oi /Ot /GL /EHsc /I %MLINCLDIR% /I %MPIINCLDIR% /I %GSINCLDIR% /Fe%TARGETNAME% main.cpp GammaSimulator.cpp DistEnv.cpp DistributionWrapper.cpp BoostedBernoulliDistribution.cpp %MATFILEIO%\MatFileIOUtils.cpp MathUtils.cpp OtherFileIOUtils.cpp %CONTAINERS%\LocalVector.cpp %CONTAINERS%\DistVector.cpp %CONTAINERS%\LocalDenseMatrix.cpp %CONTAINERS%\LocalSparseMatrix.cpp %CONTAINERS%\DistDenseMatrix.cpp %CONTAINERS%\DistSparseMatrix.cpp %SCMs%\SCMFactory.cpp %SCMs%\SCMBase.cpp %SCMs%\SimpleSCM.cpp %SCMs%\SparseSCM.cpp %SCMs%\ZeroSCM.cpp %SCMs%\UniformSCM.cpp %SCMs%\OneBitSCM.cpp %SCMs%\InPlaceSCM.cpp %ASTRO%\AstroNet.cpp %GABA%\GABA.cpp %STDP%\AnalyticStdpMechanism.cpp %STDP%\TabulatedStdpMechanism.cpp %STDP%\BaseStdpMechanism.cpp %BCUR%\BasicCurrent.cpp %XCUR%\ExtraCurrent.cpp %MODCURs%\ModCurrent.cpp %MODCURs%\AtomicModCurrentBase.cpp %MODCURs%\Autogenerated\AllModCurrents.cpp %VLTCLAMP%\VoltageClamp.cpp %MLLIBDIR%\libmat.lib %MLLIBDIR%\libmx.lib %MPILIBDIR%\msmpi.lib

@echo off

if ErrorLevel 1 goto exit

rem The next command resets the error level
del *.obj > NUL

rem Pause if we were called by hand
if "%1"=="" (
    echo.
    pause
)

:exit