#include "BasicCurrent/BasicCurrent.h"

template <typename T>
T BasicCurrent<T>::tau_n_e(T v)
{
    T sum = v + n_v_1;
    T alpha_n;
    if (sum != 0)
    {
        alpha_n = n_a_1 * sum / (1 - exp(-sum / n_a_2));
    }
    else
    {
        alpha_n = n_a_1 * n_a_2;
    }
    T beta_n = n_b_1 * exp(-(v + n_v_2) / n_b_2);
    return 1 / (alpha_n + beta_n);
}
