#include "GABA.h"
#include "MatFileIO/MatFileIOUtils.h"


template <typename T>
void GABA<T>::ReadInputDataAllocateTemporaryArrays(bool continuationMode)
{
    using namespace DistEnv;

    DeltaVGABA = ReadCheckBroadcastScalar<T>("DeltaVGABA");
    GTonicGABA = ReadCheckBroadcastScalar<T>("GTonicGABA");
    VTonicGABA = ReadCheckBroadcastScalar<T>("VTonicGABA");
    AlphaTonic = ReadCheckBroadcastScalar<T>("AlphaTonic");

    // Parameters of dynamic tonic current conductance
    enableFreqDelay = false;
    dynamicGTonicGABA = ReadCheckBroadcastScalar<bool>("dynamicGTonicGABA");
    if (dynamicGTonicGABA)
    {
        watchGTonicGABA = ReadCheckBroadcastScalar<bool>("watchGTonicGABA");

        gTonicGABAModel = (GTonicGABAModel)ReadCheckBroadcastScalar<int>("GTonicGABAModel");
        assert(gTonicGABAModel == GTonicGABAModel::First || gTonicGABAModel == GTonicGABAModel::Second);

        switch (gTonicGABAModel)
        {
            case GTonicGABAModel::First:
            {
                DoOneStepPart1_ = &GABA<T>::DoOneStepPart1_FirstModel;
                DoOneStepPart2_ = &GABA<T>::DoOneStepPart2_FirstModel;

                GTonicGABAControl = ReadCheckBroadcastScalar<T>("GTonicGABAControl");
                basicFrequency = ReadCheckBroadcastScalar<T>("basicFrequency");

                T Af = ReadCheckBroadcastScalar<T>("Af");
                const1 = num_i * Af;

                freq_i = 0;

                break;
            }
            case GTonicGABAModel::Second:
            {
                DoOneStepPart1_ = &GABA<T>::DoOneStepPart1_SecondModel;
                DoOneStepPart2_ = &GABA<T>::DoOneStepPart2_SecondModel;

                G0 = ReadCheckBroadcastScalar<T>("G0");
                Rate = ReadCheckBroadcastScalar<T>("Rate");
                GABAb = ReadCheckBroadcastScalar<T>("GABAb");

                T V = ReadCheckBroadcastScalar<T>("V");
                int N = ReadCheckBroadcastScalar<int>("N");
                T Na = ReadCheckBroadcastScalar<T>("Na");
                const2 = 1 / dt / V * N / Na;

                num_spikes_i = 0;

                break;
            }
        }

        if (continuationMode)
        {
            GTonicGABA = ReadCheckBroadcastScalar<T>("GTonicGABA", MatFile::IntermInput);
        }

        if (gTonicGABAModel == GTonicGABAModel::Second)
        {
            GABA_ = GTonicToGABAForSecondModel(GTonicGABA);
        }

        if (watchGTonicGABA)
        {
            GTonicGABA_vec = LocalVector<T>(m_steps + 1, AllocMode::onlyMasterMxCalloc);
            if (!continuationMode)
            {
                if (myRank == MASTER_RANK)
                {
                    GTonicGABA_vec[0] = GTonicGABA;
                }
            }
            else
            {
                ReadCheckInVector(GTonicGABA_vec, "GTonicGABA", m_steps_prev + 1, MatFile::Output);
            }
        }

        Gpump = ReadCheckBroadcastScalar<T>("Gpump");
        enableFreqDelay = ReadCheckBroadcastScalar<bool>("enableFreqDelay");
        if (enableFreqDelay)
        {
            freqDelay = ReadCheckBroadcastScalar<int>("freqDelay");
        }
    }
}

template <typename T>
void GABA<T>::WriteOutputData(int num_steps)
{
    // Tonic current conductance
    WriteScalar<bool>(dynamicGTonicGABA, "dynamicGTonicGABA");
    if (dynamicGTonicGABA)
    {
        WriteScalar<bool>(watchGTonicGABA, "watchGTonicGABA");
        if (watchGTonicGABA)
        {
            WriteCutVector<T>(GTonicGABA_vec, "GTonicGABA", num_steps + 1);
        }
    }
    WriteScalar<bool>(enableFreqDelay, "enableFreqDelay");
}

template <typename T>
void GABA<T>::GatherWriteIntermediateData()
{
    // Tonic current conductance
    if (dynamicGTonicGABA)
    {
        WriteScalar<T>(GTonicGABA, "GTonicGABA", MatFile::Intermediate);
    }
}
