#pragma once


template <typename T>
T ReadCheckScalar(const char *name, MatFile matFile = MatFile::Input);

template <typename T>
T ReadCheckBroadcastScalar(const char *name, MatFile matFile = MatFile::Input);

template <typename T>
T ReadCheckBroadcastScalar(const std::string &name, MatFile matFile = MatFile::Input);

// Load vector from MAT-file only to master rank.
// Extra length is allowed.
template <typename T>
LocalVector<T> ReadCheckVector(const char *name, int minLength, MatFile matFile = MatFile::Input);

// Load vector from MAT-file only to master rank.
// Extra length is not allowed.
template <typename T>
LocalVector<T> ReadCheckFixedSizeVector(const char *name, int length, MatFile matFile = MatFile::Input);

template <typename T>
LocalVector<T> ReadCheckBroadcastVector(const char *name, int length, MatFile matFile = MatFile::Input);

template <typename T>
LocalVector<T> ReadCheckBroadcastVector(const std::string &name, int length, MatFile matFile = MatFile::Input);

template <typename T>
DistVector<T> ReadCheckScatterVector(const char *name, int length, MatFile matFile = MatFile::Input);

template <typename T>
DistVector<T> ReadCheckScatterSpecialVectorFromIntermediateMat(const char *name, int length);

template <typename T>
void ReadCheckInVector(LocalVector<T> &vector, const char *name, int minLength, MatFile matFile);

template <typename T>
void ReadCheckInVector(LocalVector<T> &vector, const std::string &name, int minLength, MatFile matFile);

template <typename T>
void ReadCheckScatterInSavableVector(LocalVector<T> &localVector, DistVector<T> &distVector, const std::string &name, int length);

template <typename T, typename RNGT>
void ReadCheckInMatrix(LocalDenseMatrix<T, RNGT> &matrix, const char *name, int numRows, int numCols, MatFile matFile);

template <typename T, typename RNGT>
void ReadCheckInMatrix(LocalDenseMatrix<T, RNGT> &matrix, const std::string &name, int numRows, int numCols, MatFile matFile);

template <typename T, typename RNGT>
void ReadCheckBroadcastInMatrix(LocalDenseMatrix<T, RNGT> &matrix, const char *name, int numRows, int numCols, MatFile matFile);

template <typename T, typename RNGT>
DistDenseMatrix<T, RNGT> ReadCheckScatterMatrix(const char *name, int numRows, int numCols, MatFile matFile = MatFile::Output);

template <typename T, typename RNGT>
DistSparseMatrix<T, RNGT> ReadCheckScatterSparseMatrix(const char *name, int numRows, int numCols);

template <typename T, typename RNGT>
LocalDenseMatrix<T, RNGT> ReadCheckBroadcastMatrix(const char *name, int numRows, int numCols, MatFile matFile = MatFile::Input);

template <typename T, typename RNGT>
LocalDenseMatrix<T, RNGT> ReadCheckBroadcastMatrix(const std::string &name, int numRows, int numCols, MatFile matFile = MatFile::Input);

mxArray* ReadMxArray(const char *name);

mxArray* ReadMxArray(const std::string &name);
