#include "AtomicModCurrentBase.h"


template <typename T>
T AtomicModCurrentBase<T>::t;


template <typename T>
void AtomicModCurrentBase<T>::integrate(T dt)
{
    for (std::size_t i = 0; i < _numStates; i++)
    {
        *_states[i] += *_derivatives[i] * dt;
    }
}

template <typename T>
T AtomicModCurrentBase<T>::getResCurrent() const
{
    T resCurrent = 0;
    for (std::size_t i = 0; i < _numCurrents; i++)
    {
        resCurrent += *_currents[i];
    }
    return resCurrent;
}


template
class AtomicModCurrentBase<float>;

template
class AtomicModCurrentBase<double>;
