#pragma once

#include "Debug.h"

#include <math.h>

#include <vector>


// Constants copied from nrn-7.4/src/oc/hoc_init.c
#define PI (T)3.14159265358979323846
#define E (T)2.71828182845904523536
#define GAMMA (T)0.57721566490153286060
#define DEG (T)57.29577951308232087680
#define PHI (T)1.61803398874989484820   // golden ratio
#define FARADAY (T)96485.309            // coulombs/mole
#define R (T)8.31441                    // molar gas constant


template <typename T>
class AtomicModCurrentBase
{
public:
    T v;
    static T t;

public:
    virtual void init() { }
    virtual void states() { }
    virtual void currents() { }

    void integrate(T dt);
    T getResCurrent() const;

protected:
    // The const modifiers are commented here, because otherwise
    // the current logic of deserialization would not compile
    /* const */ size_t _numCurrents;
    /* const */ size_t _numStates;
    T** _currents;
    T** _states;
    T** _derivatives;
};