#include "VoltageClamp.h"
#include "MatFileIO/MatFileIOUtils.h"


// Called on all ranks with single thread
template <typename T>
void VoltageClamp<T>::ReadInputDataAllocateTemporaryArrays(char suffix, bool continuationMode, int numCells, int m_steps_prev, int m_steps)
{
    assert(applyClamp);

    using namespace DistEnv;

    clampedWatchedCellIdxParamName = std::string("clampedWatchedCellIdx_") + suffix;
    watchedCurrentParamName = std::string("watched_ccv_") + suffix;

    // TODO: Do not read the same parameter twice
    clampedWatchedCellIdxVerbatim = ReadMxArray(clampedWatchedCellIdxParamName);
    int clampedWatchedCellIdxOneBased = ReadCheckBroadcastScalar<int>(clampedWatchedCellIdxParamName);

    // We use 1-based indexes in Matlab and 0-based indexes in C++
    int clampedWatchedCellIdxZeroBased = clampedWatchedCellIdxOneBased - 1;

    clampedWatchedCellRank = GetRankNumber(numCells, clampedWatchedCellIdxZeroBased);

    if (myRank != clampedWatchedCellRank)
    {
        // This rank does not correspond to the cell to clamp voltage and watch current
        clampedWatchedCellLocalIdxOrMinus1 = -1;
    }
    else
    {
        clampedWatchedCellLocalIdxOrMinus1 = clampedWatchedCellIdxZeroBased - GetRankChunkStartIdx(numCells, myRank);
    }

    watched_ccv = LocalVector<T>(m_steps + 1, AllocMode::onlyMasterMxCalloc);
    if (continuationMode)
    {
        ReadCheckInVector(watched_ccv, watchedCurrentParamName, m_steps_prev + 1, MatFile::Output);
    }
}


// Called on master rank with single thread
template <typename T>
void VoltageClamp<T>::WriteOutputData(int num_steps)
{
    assert(applyClamp);
    WriteCutVector<T>(watched_ccv, watchedCurrentParamName, num_steps + 1);
    WriteMxArray(clampedWatchedCellIdxVerbatim, clampedWatchedCellIdxParamName);
}
