function pb_OK_Callback(~, ~)

    global invalidParams hf saveInput2Output
    global guiType debugMode
    global GuiTypes
    
    if ~isempty(invalidParams)
        msg = ['The following parameters are not valid:', invalidParams];
        warndlg(msg, 'Invalid parameters');
        return
    end
    
    % Re-initialize global variables containing parameters values.
    % (We need this just in case if there was an error between the "CastParams" call and the figure closing below,
    % and user clicked "OK" one more time without any changes in GUI.
    % In this case, "EvaluateAllRemainders" would fail, because it expects non-casted parameters.)
    UpdateViewControls();
    
    % Evaluate all remainders given GUI type
    if ~debugMode
        % Show error message only
        try
            EvaluateAllRemainders(guiType);
        catch ex
            warndlg(ex.message, 'Invalid parameters');
        end
    else
        % Show error message and call stack
        EvaluateAllRemainders(guiType);
    end
    
    if guiType == GuiTypes.StartFromScratch

        % Check the HPC kernel state
        [exePresent, md5Equal, newMd5FileName] = CheckWorkerAppState();
        
        if ~md5Equal || debugMode
            % Translate all the MOD files to C++ source and header files for both "e" and "i" neurons,
            % create an empty MD5-file,
            % then deploy the files to the worker source code directory
            TranslateModFilesAndDeployAutogenFiles(newMd5FileName);
        else
            disp('Don''t need to retranslate the MOD files.');
        end
        
        if ~exePresent || ~md5Equal || debugMode
            % Build the worker
            BuildWorker();
        else
            disp('Don''t need to rebuild the worker.');
        end
    end
    
    % Cast parameters to proper types: single, int32 or logical
    if guiType == GuiTypes.StartFromScratch
    	CastParams();
    end
    
    % Save input parameters
    if saveInput2Output
        SaveParams('guiParams.mat');
    end
    
    [okHandler, stopAfter] = GuiTypeToOkHandler(guiType);
    
    % Close the figure as late as possible so that maximum number of errors could occur before it is closed
    close(hf);
    
    okHandler();
    
    if stopAfter
        return
    end
      
    % Grab output MAT-file from remote cluster or HPC kernel directory
    getFromSnapshot = false;
    GrabReadAndVisualizeResults(getFromSnapshot);

end
