#include "GammaSimulator.h"

// Input vectors:        v_e, gts1, gts2, I_e, s_e, tau_r_e, tau_d_e
// Input scalars:        num_e, v_rev_e, v_rev_i, g_stoch_e, DeltaVGABA, GTonicGABA, VTonicGABA, dt05, r_e
// Output vectors:       v_e_tmp, s_e_tmp, v_e_old
// Input/output objects: basicCurrent_e, extraCurrent_e, modCurrent_e
// Input/output vectors: s_stoch_e
template <typename T, typename RNGT>
void GammaSimulator<T, RNGT>::ElementwiseOperation1()
{
    using namespace DistEnv;

    if (enableBasicCurrent_e)
    {
        basicCurrent_e.DoOneStepPart1(v_e);
    }

    if (enableExtraCurrent_e)
    {
        extraCurrent_e.DoOneStepPart1(v_e);
    }

    if (importMod_e)
    {
        modCurrent_e.DoOneStepPart1(v_e);
    }

    int startIdx, endIdx;
    GetMyThreadChunkStartEndIdxs(v_e.localLength, startIdx, endIdx);

    for (int idx = startIdx; idx < endIdx; idx++)
    {
        T delta = v_rev_e - v_e[idx];
        
        // !! TODO: Fix units inconsistency between v_e_inc and I_e
        T v_e_inc = T(0.1) * (-67 - v_e[idx]) +
            gts1_e[idx] * delta + gts2_e[idx] * (gaba.DeltaVGABA + v_rev_i - v_e[idx]) + imageDrive[idx] +
            basicCurrent_e.I[idx] + I_e[idx] + extraCurrent_e.I[idx] + modCurrent_e.I[idx] +
            g_stoch_e * s_stoch_e[idx] * delta + gaba.AlphaTonic * gaba.GTonicGABA * (gaba.DeltaVGABA + gaba.VTonicGABA - v_e[idx]);

        T s_e_inc = T(0.5) * (1 + tanh(v_e[idx] / 4)) * (1 - s_e[idx]) / tau_r_e[idx] - s_e[idx] / tau_d_e[idx];
        
        v_e_tmp[idx] = v_e[idx] + dt05 * v_e_inc;
        s_e_tmp[idx] = s_e[idx] + dt05 * s_e_inc;
        s_stoch_e[idx] *= r_e;
        
        v_e_old[idx] = v_e[idx];
    }
}