#include "GammaSimulator.h"

// Input vectors:        v_i, gts1_i, gts2_i, I_i, s_i, tau_r_i, tau_d_i
// Input scalars:        num_i, v_rev_e, v_rev_i, g_e, StimInter, g_stoch_i, GTonicGABA, VTonicGABA, dt05, r_i
// Output vectors:       v_i_tmp, s_i_tmp, v_i_old
// Input/output objects: basicCurrent_i, extraCurrent_i, modCurrent_i
// Input/output vectors: s_stoch_i
template <typename T, typename RNGT>
void GammaSimulator<T, RNGT>::ElementwiseOperation2()
{
    using namespace DistEnv;

    if (enableBasicCurrent_i)
    {
        basicCurrent_i.DoOneStepPart1(v_i);
    }

    if (enableExtraCurrent_i)
    {
        extraCurrent_i.DoOneStepPart1(v_i);
    }

    if (importMod_i)
    {
        modCurrent_i.DoOneStepPart1(v_i);
    }

    int startIdx, endIdx;
    GetMyThreadChunkStartEndIdxs(v_i.localLength, startIdx, endIdx);

    for (int idx = startIdx; idx < endIdx; idx++)
    {
        T delta = v_rev_e - v_i[idx];
        
        T v_i_inc = T(0.1) * (-65 - v_i[idx]) +
            g_e * gts1_i[idx] * delta + gts2_i[idx] * (v_rev_i - v_i[idx]) +
            basicCurrent_i.I[idx] + StimInter * I_i[idx] + extraCurrent_i.I[idx] + modCurrent_i.I[idx] +
            g_stoch_i * s_stoch_i[idx] * delta + gaba.GTonicGABA * (gaba.VTonicGABA - v_i[idx]);

        T s_i_inc = T(0.5) * (1 + tanh(v_i[idx] / 4)) * (1 - s_i[idx]) / tau_r_i[idx] - s_i[idx] / tau_d_i[idx];
        
        v_i_tmp[idx] = v_i[idx] + dt05 * v_i_inc;
        s_i_tmp[idx] = s_i[idx] + dt05 * s_i_inc;
        s_stoch_i[idx] *= r_i;
        
        v_i_old[idx] = v_i[idx];
    }
}