#include "GABA.h"


template <typename T>
void GABA<T>::DoOneStepPart1()
{
    // Update GTonicGABA
    #pragma omp barrier
    #pragma omp master
    {
        if (dynamicGTonicGABA)
        {
            // Call DoOneStepPart1_FirstModel or DoOneStepPart1_SecondModel
            (this->*DoOneStepPart1_)();
        }
    }
    #pragma omp barrier
}


template <typename T>
void GABA<T>::DoOneStepPart1_FirstModel()
{
    GTonicGABA_old = GTonicGABA;
    T GTonic_der = GTonic_rhp();
    GTonicGABA += dt05 * GTonic_der;
}


template <typename T>
void GABA<T>::DoOneStepPart1_SecondModel()
{
    GABA_old = GABA_;
    T GABA_der = GABA_rhp();
    GABA_ += dt05 * GABA_der;
    GTonicGABA = GABAToGTonicForSecondModel(GABA_);
}
