#pragma once


template <typename T>
void WriteScalar(T scalar, const char *name, MatFile matFile = MatFile::Output);

template <typename T>
void WriteScalar(T scalar, const std::string &name, MatFile matFile = MatFile::Output);

template <typename T>
void WriteVector(const LocalVector<T> &vector, const char *name, MatFile matFile = MatFile::Output);

template <typename T>
void WriteVector(const LocalVector<T> &vector, const std::string &name, MatFile matFile = MatFile::Output);

template <typename T>
void GatherWriteSpecialVectorToIntermediateMat(const DistVector<T> &vector, const char *name);

template <typename T, typename RNGT>
void WriteMatrix(const LocalDenseMatrix<T, RNGT> &matrix, const char *name, MatFile matFile);

template <typename T>
void WriteCutVector(LocalVector<T> &vector, const char *name, int currentLength, MatFile matFile = MatFile::Output);

template <typename T, typename RNGT>
void WriteCutMatrix(LocalDenseMatrix<T, RNGT> &matrix, const char *name, int currentNumCols, MatFile matFile);

template <typename T, typename RNGT>
void WriteCutMatrix(LocalDenseMatrix<T, RNGT> &matrix, const std::string &name, int currentNumCols, MatFile matFile);

void WriteMxArray(mxArray *pArray, const char *name);

void WriteMxArray(mxArray *pArray, const std::string &name);
