#pragma once

#include "Containers/DistVector.h"


// This class contains virtual methods used in case user does not import any MOD currents
template <typename T>
class AllModCurrentsBase
{
public:
    DistVector<T> I;
    
protected:
    AllModCurrentsBase(int num)
    {
        I = DistVector<T>(num);
        I.AssignZeros();
    }
    
public:
    virtual void SetVoltage(const DistVector<T> &v) { }
    
    virtual DistVector<T> GetSumCurrent()
    {
        return I;
    }
    
    virtual void DoOneStepPart1(const DistVector<T> &v, T dt05) { }
    
    virtual void DoOneStepPart2(const DistVector<T> &v, const DistVector<T> &v_tmp, T dt05) { }
    
    virtual void GatherWriteIntermediateData() { }
};
