#include "ModCurrent.h"
#include "MatFileIO/MatFileIOUtils.h"

// Load data from input MAT-file
template <typename T, typename RNGT>
void ModCurrent<T, RNGT>::ReadInputDataAllocateTemporaryArrays(bool continuationMode, bool enable)
{
    // The current itself
    I = p_AllModCurrents->I;

    if (enable)
    {
        // Parameters of visualization
        watchedModCurrentNum = ReadCheckBroadcastScalar<int>("watchedModCurrentNum_" + suffix);

        if (watchedModCurrentNum != 0)
        {
            ReadTransitMxArrays();

            watchedModCurrentIdx = ReadCheckBroadcastVector<int>("watchedModCurrentIdx_" + suffix, watchedModCurrentNum);

            // Adjust 1-based Matlab indices to 0-based
            for (int i = 0; i < watchedModCurrentIdx.length; ++i)
            {
                --watchedModCurrentIdx[i];
            }

            watchedModCurrentI = LocalDenseMatrix<T, RNGT>(watchedModCurrentNum, m_steps + 1, AllocModeMatrix::MasterMxCalloc);

            if (continuationMode)
            {
                ReadCheckInMatrix<T, RNGT>(watchedModCurrentI, "watchedModCurrentI_" + suffix, watchedModCurrentNum, m_steps_prev + 1, MatFile::Output);
            }
        }
    }
}

// Read data from the input MAT-file to write in the output MAT-file.
// The method is called just on master rank.
template <typename T, typename RNGT>
void ModCurrent<T, RNGT>::ReadTransitMxArrays()
{
    watchedModCurrentIdxOneBased = ReadMxArray("watchedModCurrentIdx_" + suffix);
}

// Write data to intermediate MAT-file.
// The method is called on all ranks with any number of threads, but not inside "#pragma omp master" region.
template <typename T, typename RNGT>
void ModCurrent<T, RNGT>::GatherWriteIntermediateData()
{
    p_AllModCurrents->GatherWriteIntermediateData();
}

// Write data to output MAT-file.
// The method is called just on master thread of master rank.
template <typename T, typename RNGT>
void ModCurrent<T, RNGT>::WriteOutputData(int num_steps)
{
    WriteScalar<int>(watchedModCurrentNum, "watchedModCurrentNum_" + suffix);

    if (watchedModCurrentNum != 0)
    {
        WriteTransitMxArrays();
        WriteCutMatrix<T, RNGT>(watchedModCurrentI, "watchedModCurrentI_" + suffix, num_steps + 1, MatFile::Output);
    }
}

// Transfer data from the input MAT-file to the output MAT-file.
// The method is called just on master rank.
template <typename T, typename RNGT>
void ModCurrent<T, RNGT>::WriteTransitMxArrays()
{
    WriteMxArray(watchedModCurrentIdxOneBased, "watchedModCurrentIdx_" + suffix);
}
