function AddPaths(addBuildUtils)
%% Depending on "isdeployed" value, add paths of folders with m-files to the Matlab search path
%  or add paths of JAR files to the dynamic Java class path

    global hostDirPaths
    
    if ~isdeployed
        if nargin == 0
            addBuildUtils = false;
        end

        % Add paths
        addpath(cd);
        addpath(genpath(fullfile(cd, 'Core')));
        addpath(genpath(fullfile(cd, 'GUI')));
        addpath(genpath(fullfile(cd, 'MainMenuGUI')));
        addpath(fullfile(cd, 'DashboardGUI'));
        if addBuildUtils
            addpath(fullfile(cd, 'BuildUtils'));
        end

        % Remove paths of inner folders that do not contain m-files
        rmpath(fullfile(cd, 'Core', '3rdparty'));
        rmpath(fullfile(cd, 'Core', 'ModFileUtils', 'CppFilesGenerators', 'Templates'));
        rmpath(genpath(fullfile(cd, 'Core', 'scripts')));
    else
        % Widgets Toolbox
        javaaddpath(fullfile(hostDirPaths.Code, 'Core', '3rdparty', 'MathWorksConsultingWidgets.jar'));
    end
    
end
