function outDirPath = PrepareEmptyDirDeployNonMFiles(outDirName, tempSubDirName)
%% Prepare empty output directory and deploy all needed non-M files to its temporary subdirectory

    % Create a new or clean up the existing target directory
    outDirPath = fullfile(cd, '..', outDirName);
    PrepareEmptyDir(outDirPath);
    
    % Copy all dependent non-M files to the target directory
    
    disp('Copying non-M files ...');
    
    srcDir = cd;
    dstDir = fullfile(outDirPath, tempSubDirName);
    
    if ispc
        CopyOneDirOrFile(srcDir, dstDir, 'Core', '3rdparty');
        CopyOneDirOrFile(srcDir, dstDir, 'Core', 'scripts', 'win-lin');
        CopyOneDirOrFile(srcDir, dstDir, 'assets');
        % We may want to support the "win-win" mode (probably with "FakeMPIRelease" configuration only) in the future
        % CopyOneDirOrFile(srcDir, dstDir, 'Core', 'scripts', 'win-win');
    elseif isunix
        CopyOneDirOrFile(srcDir, dstDir, 'Core', 'scripts', 'lin-lin');
    else
        error('Not supported OS');
    end
    
    CopyOneDirOrFile(srcDir, dstDir, 'Core', 'ModFileUtils', 'CppFilesGenerators', 'Templates');
    
    CopyOneDirOrFile(srcDir, dstDir, 'LICENSE');
    CopyOneDirOrFile(srcDir, dstDir, '3rdParty.txt');
    
    % Deploy Widgets Toolbox JAR file
    personalLocation = GetPersonalLocation();
    srcFile = fullfile(personalLocation, 'MATLAB', 'Add-Ons', 'Toolboxes', 'Widgets Toolbox', 'code', 'resource', 'MathWorksConsultingWidgets.jar');
    thirdPartyDstDir = fullfile(dstDir, 'Core', '3rdparty');
    CopyOneDirOrFile(srcFile, thirdPartyDstDir);
    
end


function CopyOneDirOrFile(srcDirOrFile, dstDirOrFile, varargin)
%% Copy one directory or file
    
    copyfile(...
        fullfile(srcDirOrFile, varargin{:}), ...
        fullfile(dstDirOrFile, varargin{:}), ...
        'f');
    
end
