function g = GenerateScm(suf, g_hat, w_max, numRows, numCols, scmType, sclModel, useSPA, sigma)
%% Generate Synaptic Conductance Matrix or return NaN if we should not generate it

    global ScmTypes
    
    switch scmType
        case {ScmTypes.AllZeros, ScmTypes.AllEqual}
            fprintf('    g_%s is not generated explicitly because it has a primitive structure.\n', suf);
            g = nan;
        case ScmTypes.HstDense
            fprintf('    Generating g_%s ...\n', suf);
            g = GenerateDenseScm(suf, numRows, numCols, w_max, g_hat, sclModel, useSPA, sigma);
        case ScmTypes.HstSparse
            fprintf('    Generating g_%s ...\n', suf);
            g = GenerateSparseScm(suf, numRows, numCols, w_max, g_hat, sigma);
        otherwise
            fprintf('    g_%s will be generated in HPC kernel.\n', suf);
            g = nan;
    end
    
end