function md5Equal = CheckMd5File(newMd5FileName)
%% Check whether the old autogenerated code for MOD files became obsolet
    
    global remoteHPC
    
    if ispc
        command = ScriptCallCommand('check_file');
        if remoteHPC
            separator = '/';
        else
            separator = '\';
        end
        path = strjoin({'ModCurrents', 'Autogenerated', newMd5FileName}, separator);
        command = [command, ' ', path];
        
        disp('Checking MD5-code for MOD currents ...');
        
        status = system(command);
        
        md5Equal = (status == 0);
        
        if md5Equal
            disp('Equal.');
        else
            disp('Not equal.');
        end
        
    elseif isunix
        error('Not implemented');
    else
        error('Not supported OS');
    end
    
end