function hashStr = GetMd5ForModData()
%% Compute MD5-code based on content of the selected MOD-files and values of the assigned parameters

    global importMod_e modParams_e modFileNames_e   %#ok<NUSED>
    global importMod_i modParams_i modFileNames_i   %#ok<NUSED>
    global modDirPath_e
    global modDirPath_i
    global HostDirTypes
    
    % Prepare a temporary MAT-file
    tempMatFilePathName = fullfile(GetDirPath(HostDirTypes.Temp), '_md5Temp.mat');
    save(tempMatFilePathName, 'importMod_e', 'importMod_i');
    if importMod_e
        save(tempMatFilePathName, '-append', 'modFileNames_e', 'modParams_e');
    end
    if importMod_i
        save(tempMatFilePathName, '-append', 'modFileNames_i', 'modParams_i');
    end
    
    n1 = length(modFileNames_e);
    n2 = length(modFileNames_i);
    modFilesPathsNames = cell(n1 + n2, 1);
    
    ext = '.mod';
    
    % Prepare paths of MOD-files for e-neurons
    for i = 1 : n1
        modFilesPathsNames{i} = fullfile(modDirPath_e, [modFileNames_e{i}, ext]);
    end
    
    % Prepare paths of MOD-files for i-neurons
    for i = 1 : n2
        modFilesPathsNames{n1 + i} = fullfile(modDirPath_i, [modFileNames_i{i}, ext]);
    end
    
    hashStr = GetMd5ForFiles(tempMatFilePathName, modFilesPathsNames);
    
    delete(tempMatFilePathName);

end

function hashStr = GetMd5ForFiles(tempMatFilePathName, modFilesPathsNames)
%% Compute MD5-code based on content of the files
%  http://stackoverflow.com/questions/12140458/calculating-md5-hash-rfc-1321-conform-in-matlab-via-java
    
    mdDigest = java.security.MessageDigest.getInstance('MD5');
    
    hdrSize = 128;  % eq. 2 ^ 7
    bufSize = 8192; % eq. 2 ^ 13
        
    fid = fopen(tempMatFilePathName);
    assert(fid ~= -1);
        
    % Ignore the title of mat file, for example:
    % MATLAB 5.0 MAT-file, Platform: PCWIN64, Created on: Fri Dec 02 19:42:50 2016
    fread(fid, hdrSize, '*uint8');
    while ~feof(fid)
        [currData, len] = fread(fid, bufSize, '*uint8');
        if ~isempty(currData)
            mdDigest.update(currData, 0, len);
        end
    end
    
    fclose(fid);
    
    for i = 1 : length(modFilesPathsNames)
        filePathName = modFilesPathsNames{i};
        
        fid = fopen(filePathName);
        assert(fid ~= -1);
        
        dirPath = fileparts(filePathName);
        lines = {};
        while ~feof(fid)
            cline = fgetl(fid);
            lines = ProcessIncludeDirectivesRecursively(lines, cline, dirPath);
        end

        byteLines = getByteStreamFromArray(lines);
        mdDigest.update(byteLines, 0, length(byteLines));
        
        fclose(fid);
    end
    
    hashInt8 = mdDigest.digest();
    hashUInt8 = typecast(hashInt8, 'uint8');
    hashHexStr2d = dec2hex(hashUInt8);
    hashHexStr1d = reshape(hashHexStr2d, 1, []);
    hashStr = lower(hashHexStr1d);
    
end
