function notInitCurrentParams = FindAllCurrentsInBlocks(parametersBlocks)

    assignedParams = ParseAssignedBlock(parametersBlocks.ASSIGNED);
    parameterParams = ParseParameterBlock(parametersBlocks.PARAMETER);

    notInitCurrentParams = FindAllCurrentsInBlock(assignedParams);
    notInitCurrentParams = FindAllCurrentsInBlock(parameterParams, notInitCurrentParams);
    
end

function notInitCurrentParams = FindAllCurrentsInBlock(params,   notInitCurrentParams)

    if nargin == 1
        notInitCurrentParams = {};
    end
    
    for i = 1 : length(params)
        tmpStr = params{i};

        if contains(tmpStr, '=')
            continue
        end

        if tmpStr(1) == 'i'
            notInitCurrentParams{end + 1, 1} = params{i}; %#ok<AGROW>
        end
    end

end
