function SetLastLoginPassword(isLoggedIn,   login, password)
%% Save the last used login and password to registry
%  !! Pass loginInfo struct

    assert(ispc);
    
    % Since we cannot write into the location under HKEY_LOCAL_MACHINE (used by Arachne uninstaller) without elevated permissions,
    % we have to write somewhere under HKEY_CURRENT_USER
    % https://stackoverflow.com/questions/4844441/changing-registry-without-admin-rights
    
    % !! use the same global var in GetLastLoginPassword
    keyName = 'HKCU\SOFTWARE\UCL Institute of Neurology\Arachne';
    
    if isLoggedIn
        commandPat = 'reg add "%s" /v %s /d %s /f > NUL';
        
        % !! need to save encrypted login for security
        command = sprintf(commandPat, keyName, 'LastLogin', login);
        status = system(command);
        assert(status == 0);
        
        % !! need to save encrypted password for security
        command = sprintf(commandPat, keyName, 'LastPassword', password);
        status = system(command);
        assert(status == 0);
    else
        commandPat = 'reg delete "%s" /v %s /f > NUL';
        
        command = sprintf(commandPat, keyName, 'LastLogin');
        status = system(command);
        assert(status == 0);
        
        command = sprintf(commandPat, keyName, 'LastPassword');
        status = system(command);
        assert(status == 0);
    end
    
end
