function success = CallWithErrorHandlingPolicy(foo, title,   isCritical)
%% Call the function with the error handling policy dependent on "debugMode", "mobileMode" and "isCritical"

    global debugMode mobileMode
    
    if nargin == 2
        isCritical = false;
    end
    
    success = true;
    
    if ~debugMode && ~mobileMode
        % In the case of error, show a warning messagebox with the error info (without callstack) and beep.
        % If the error is not critical, then give user a chance to repeat the operation (i.e. do not abort the program).
        % Otherwise, throw the exception.
        try
            foo();
        catch ex
            h = warndlg(ex.message, title, 'modal');
            beep();
            uiwait(h);
            if isCritical
                % Print a red message (with callstack) to console, beep, then abort the program
                throw(ex);
            else
                success = false;
            end
        end
    else
        % In the case of error, print a red message (with callstack) to console, beep, then abort the program
        foo();
    end
    
end
