function ComputeStdDevsAndPvhParams(correctDeltasAutomatically)
%% Compute the standard deviations and parameters of presynaptic voltage history matrices.
%  The next global variables are assigned: sigma_**, delta_**, max_delay_*
    
    global num_e num_i
    global sigma_ee sigma_ei sigma_ie sigma_ii
    global sigmaDivisor_ee sigmaDivisor_ei sigmaDivisor_ie sigmaDivisor_ii
    global radius_e radius_i v
    global delta_ee delta_ii delta_ei delta_ie
    global max_delay_e max_delay_i
    global DialogIds
    
    % Compute standard deviations for normal distributions
    % (widths of the bell-shaped functions).
    % sigma_xy = max_matrix_dimension / sigmaDivisor_xy.
    sigma_ee = num_e / sigmaDivisor_ee;
    num_max = max(num_e, num_i);
    sigma_ei = num_max / sigmaDivisor_ei;
    sigma_ie = num_max / sigmaDivisor_ie;
    sigma_ii = num_i / sigmaDivisor_ii;
    
    % Compute the signal propagation rate (how many neighbour neurons can be affected by a given neuron per one iteration)
    rx = (radius_e + radius_i) / 2 + abs(radius_e - radius_i);
    num_x = (num_e + num_i) / 2 + abs(num_e - num_i);
    delta_ee = round(2 * pi * radius_e / (num_e * v));
    delta_ii = round(2 * pi * radius_i / (num_i * v));
    delta_ei = round(2 * pi * rx / (num_x * v));
    delta_ie = delta_ei;
    
    if correctDeltasAutomatically
        CorrectDeltas();
    else
        % Validate parameters of presynaptic voltage history matrices
        if (delta_ee == 0) || (delta_ei == 0) || (delta_ie == 0) || (delta_ii == 0)
            msg = 'The set of input parameters does not allow accurate FDTD modelling.';
            % !! use 'warning' icon?
            button = QuestDlg(...
                DialogIds.ContinueWithBadParams, ...
                sprintf('%s\nDo you want to continue?', msg), ...
                'Continue operation', ...
                'Yes', 'No', ...
                'No');
            if strcmp(button, 'Yes')
                CorrectDeltas();
            elseif strcmp(button, 'No')
                error(msg);
            end
        end 
    end
    
    max_delay_e = max(delta_ee, delta_ei) * num_e;
    max_delay_i = max(delta_ie, delta_ii) * num_i;
    
end

function CorrectDeltas()
%% Correct delta_** to avoid zero values

    global delta_ee delta_ii delta_ei delta_ie
    
    if delta_ee == 0
        delta_ee = 1;
    end
    if delta_ei == 0
        delta_ei = 1;
    end
    if delta_ie == 0
        delta_ie = 1;
    end
    if delta_ii == 0
        delta_ii = 1;
    end
    
end
