function PlotCurrentAtClampedVoltage(time, current, suffix, watchedCellIdx)
%% Plot current vs time for selected neuron at clamped voltage

    if suffix == 'e'
        color = 'r';
    else
        color = 'b';
    end
    xRange = [time(1), time(end)];
    figure('Name', sprintf('Current (%s-%i)', suffix, watchedCellIdx), 'NumberTitle', 'off');
    plot(time, current, color);
    grid on
    set(gca, 'xlim', xRange);
    xlabel('time, ms');
    ylabel('current, pA');
    title('Current at clamped voltage');
    str = sprintf('%s-cell with index %i', suffix, watchedCellIdx);
    legend(str);

end