function [success, response] = CallWebWriteWithErrorHandlingPolicy(url, data, options)
%% !!

    % !!
    success = true;
    response = struct;
    return
    
    try
        response = webwrite(url, data, options); % !! do I need to specify the options
    catch
        % !! Show msgbox here (if not debug)
        success = false;
        response = struct;
        return
        % !!
    end
    
    % !! do I need to check HTTP code here? 
    
    response = jsondecode(response.data);
    assert(isfield(response, 'status'), 'Bad response format'); % Dev. assert (!!?)
    
    status = response.status;
    success = (status == 0);
    % !! Show msgbox here (if not debug)
    assert(success, 'Bad status');  % !! need to call with error handling policy
    
end
