function [success, login] = SerReqAccLogIn(loginOrEmail, password)
%% !!

    url = PrepareAccOpURL('login');
    options = weboptions('MediaType', 'application/json');  % !! think about caching options
    data = struct('loginOrEmail', loginOrEmail, 'password', password);
    [success, out] = CallWebWriteWithErrorHandlingPolicy(url, data, options);
    
    if ~success
        login = '';
        return
    end
    
    isLogin = ~contains(loginOrEmail, '@');
    if isLogin
        login = loginOrEmail;
        return
    end
    
    % !!
    out.login = loginOrEmail;
    
    % !! validate that the field is present in out
    assert(isfield(out, 'login'), 'Bad response format');  % Dev. assert (!!?)
    login = out.login;
    
end
