function TakeSnapshot(varargin)
%% Common entry point for both desktop and mobile versions of Matlab
 
    % !! clean global vars
    
    clc;
    
    global guiType GuiTypes
    global pushbutton_OK_Delegate
    
    BasicParams(varargin{:});
    
    guiType = GuiTypes.ScriptTakeSnapshot;
    pushbutton_OK_Delegate = @SCRIPT_Core;
    
    PrepareAndShowGUI();
    
end

function SCRIPT_Core()
 
    global c4ePeriodSec
    global mainScenarioMsg
    
    % Make sure that the kernel is running at the moment
    isRunning = CheckIfRunning();
    if ~isRunning
        disp('HPC kernel process is not active.');
        fprintf('You can %s to grab simulation results.\n', mainScenarioMsg);
        return
    end

    command = ScriptCallCommand('send_command');

    disp('Asking HPC kernel for dumping a snapshot ...');
    status = system([command, ' snapshot']);
    if status ~= 0
        error('Failed to do the request.');
    end
    disp('Request submitted.');

    while true
        % Wait
        pause(c4ePeriodSec);

        % Check if HPC kernel has dumped a snapshot
        isPresent = CheckFileExists('iofiles', 'kernel-host', 'snapshot', 'output.mat');
        if ~isPresent
            disp('HPC kernel has not dumped a snapshot yet ...');
        else
            disp('HPC kernel has dumped a snapshot.');
            break
        end
    end

    %% Grab output MAT-file from remote cluster or HPC kernel directory
    getFromSnapshot = true;
    GetOutputMat(getFromSnapshot);

    %% Read output MAT-file from disk and visualize current results of simulation
    ReadAndVisualizeResults();

    %% Clean up HPC kernel snapshot directory
    DeleteSnapshot();

end