function reply = Input(questionId, prompt)
%% Get user's answer to the given question.
%  This is basically a wrapper of "input" function that supports a predefined answer.
%  If we are called from Matlab mobile, then the predefined answer is required,
%  because Matlab mobile does not support interaction with user at runtime.

    global QuestionIds
    global userChoices mobileMode
    
    % Try to get a predefined answer
    fieldName = GetFieldName(QuestionIds, questionId);
    try
        reply = userChoices.(fieldName);
        pa = true;
    catch
        pa = false;
    end
    
    if mobileMode || pa
        % Print the question
        fprintf(prompt);
    end
    
    if pa
        % Just for convenience so that user can specify a number for the predefined answer
        if isfloat(reply)
            reply = num2str(reply);
        end
        
        % Print the predefined answer
        disp(reply);
    else
        if mobileMode
            % Close the question line and add a blank line
            fprintf('\n\n');
        
            % Interaction with user is impossible
            UserChoiceError(fieldName);
        else
            % The interaction
            reply = input(prompt, 's');
        end
    end
    
end
