function CheckMemReq()
%% Check memory requirements taking into scope that
%  the matrices are the biggest objects used in simulation.
%  Do not start simulation if there is no enough physical memory on cluster nodes.
    
    global remoteHPC memPerNodeLimit
    global computeMaxModelSizeScenarioMsg
    
    if ~remoteHPC
        return
    end
    
    % Compute the amount of physical memory required per one node of the cluster (in MB)
    [memPerNodeReq, estMsg, limMsg] = CountTotalMemReq();
    
    % Compare the required memory with the limit
    assert(memPerNodeReq <= memPerNodeLimit, ...
        ['Simulation of the model with the given set of parameters will require too much physical memory on the cluster.\n', ...
         '(At least one node will run into the memory deficit.)\n\n', ...
         '%s\n%s\n\n', ...
         'Please decrease the network size (num_e and/or num_i) or adjust other parameters to reduce the amount of allocated memory.\n', ...
         'You can %s to see a subset of model parameters that determine the memory requirements.'], ...
         estMsg, limMsg, computeMaxModelSizeScenarioMsg);
     
     disp(estMsg);
     
end