function AddCustomParams()

    AddPanel('Custom');
    
    text = {'customVars.SynWeight = 0.8;'};
    desc = {'Text area for custom m-code where you can define any additional variables accessible from the expressions in editboxes.', ...
            'The variables must be put into the %customVars struct.', ...
            '', ...
            '<b>Example:</b>', ...
            '<pre>customCode:  customVars.r = roots([1, -3.1, 0.3]);', ...
            '             customVars.myVar3 = 0.1;', ...
            '             n = 1000; % not exposed variable', ...
            '             customVars.myVar5 = log10(n);</pre>', ...
            '<b>Correct referencing:</b>', ...
            '<pre>tau_r_e:  r(2) * ones(num_e, 1)             [ms]', ...
            'tau_d_e:  r(1) * ones(num_e, 1)             [ms]', ...
            'tau_r_i:  myVar3 * myVar5 * ones(num_i, 1)  [ms]', ...
            'tau_d_i:  myVar5 ^ 2 * ones(num_i, 1)       [ms]</pre>(no "customVars." prefixes are required here)', ...
            '', ...
            '<b>Incorrect referencing:</b>', ...
            '<pre><font color="red">freqDelay:  n                               [ms]</font></pre>(the variable "n" was not exposed)'};
    
    AddCustomCodeTextArea('customCode', text, 'customVars', desc);
    
end