function AddHpcParams()

    global ScmTypes scalTest installedMode remoteHPC
    
    AddPanel('HPC');
    
    if ~installedMode
        AddBoolScalar('fakeMPI', false, 'Whether to use the fake MPI version of Arachne');
    end
    
    desc = {'On/off scalability test', ...
            '<b>unchecked:</b> <i>run HPC kernel once for number of processes equal %np and number of threads equal %nt</i>', ...
            '<b>checked:</b> <i>run HPC kernel sequentially for number of processes equal %minNP, %minNP + 1, ..., %maxNP and number of threads equal 1, 2, ..., %maxNT'};
    AddBoolScalar('scalTest', scalTest, desc);
    AddPosIntScalar('np', 1, 'Number of MPI processes', '~scalTest && ~fakeMPI');
    AddPosIntScalar('nt', 4, 'Number of OMP threads per MPI process', '~scalTest');
    relPred = 'minNP < maxNP || (minNP == maxNP && maxNT > 1)';
    AddPosIntScalar('minNP', 1, 'Minimum number of MPI processes', 'scalTest', relPred);
    AddPosIntScalar('maxNP', 4, 'Maximum number of MPI processes', 'scalTest', relPred);
    AddPosIntScalar('maxNT', 4, 'Maximum number of OMP threads per MPI process', 'scalTest', relPred);
    
    if ~installedMode
        desc = {'Whether to use remote High Performance Computing server', ...
                '<b>unchecked:</b> <i>call HPC kernel on this machine/cluster</i>', ...
                '<b>checked:</b> <i>call HPC kernel on remote machine/cluster</i>'};
        AddBoolScalar('remoteHPC', remoteHPC, desc, '~fakeMPI');
    end
    AddStringVector('loadedNodes', GetAvailableNodesStr(), 'List of nodes to run simulation on', 'remoteHPC && ~fakeMPI', 'valPred_loadedNodes(loadedNodes)');
    
    desc = {'Whether input/output MAT-files should be zipped before and unzipped after transferring between local machine and head node of the cluster.', ...
            '<b>unchecked:</b> <i>the files are transferred without compressing</i>', ...
            '<b>checked:</b> <i>the files are compressed before and decompressed after transferring</i>'};
    AddBoolScalar('zipMatFiles', true, desc, 'remoteHPC');
    
    scmTypesList = fieldnames(ScmTypes);
    scmTypesDesc = {'The matrix is not generated explicitly. <br>All elements are zeros', ...
                    'The matrix is not generated explicitly. <br>All elements are equal', ...
                    'The matrix is generated in Matlab and saved to input MAT-file with other data. <br>The matrix is generated in dense form', ...
                    'The matrix is generated in Matlab and saved to input MAT-file with other data. <br>The matrix is generated in sparse form', ...
                    'The matrix is generated in HPC kernel before 1st iteration already in distributed form. <br>An element of the matrix is stored in floating-point-number format', ...
                    'The matrix is generated in HPC kernel before 1st iteration already in distributed form. <br>The matrix is generated in sparse form', ...
                    'The matrix is generated in HPC kernel before 1st iteration already in distributed form. <br>An element of the matrix is stored in one bit', ...
                    'The matrix is re-generated in HPC kernel on each iteration'};
    AddList('scmType_ee', scmTypesList, ScmTypes.KrnDense, 'Type of synaptic conductance matrix', scmTypesDesc);
    AddList('scmType_ei', scmTypesList, ScmTypes.KrnDense, 'Type of synaptic conductance matrix', scmTypesDesc);
    AddList('scmType_ie', scmTypesList, ScmTypes.KrnDense, 'Type of synaptic conductance matrix', scmTypesDesc);
    AddList('scmType_ii', scmTypesList, ScmTypes.KrnDense, 'Type of synaptic conductance matrix', scmTypesDesc);
    
    AddBoolScalar('useSPA', true, 'Use Single Precision Arithmetics instead of double precision one');
    
    desc = {'In what mode matrices of presynaptic voltage history will be presented', ...
            '<b>unchecked:</b> <i>local mode</i>', ...
            '<b>checked:</b> <i>distributed mode</i>'};
    
    AddBoolScalar('distMatPVH', false, desc, '~(fakeMPI || remoteHPC)');
    
    desc = {'How often HPC kernel should report its progress?', ...
            'The report will be done once per <i>%reportPeriodIter</i> iterations.'};
    AddIterCounter('reportPeriod', 100, desc);
    
    desc = {'Whether to save intermediate data file "intermediate.mat that makes it possible to stop simulation and continue afterwards from the same point.', ...
            'The file is saved when:', ...
            '1) specified %t_final is reached;', ...
            '2) termination is requested by user;', ...
            '3) %saveBackupMats == true and current iteration number is evenly divisible by %backupPeriodIter.'};
    AddBoolScalar('saveIntermMat', true, desc, '~distMatPVH');
    
    desc = {'Whether backup files should be saved periodically.', ...
            'If %saveIntermMat == false, then only "output.mat" is saved,', ...
            'if %saveIntermMat == true, then both "output.mat" and "intermediate.mat" are saved periodically.'};
    AddBoolScalar('saveBackupMats', false, desc);
    
    desc = {'How often backup files should be saved?', ...
            'The saving will be done once per <i>%backupPeriodIter</i> iterations.'};
    AddIterCounter('backupPeriod', 10000, desc, 'saveBackupMats');
    
    AddBoolScalar('backgroundMode', remoteHPC, 'Whether to run HPC kernel in background mode', '~(scalTest || remoteHPC)');
    
    desc = {'How often Matlab host should check the status of HPC kernel?', ...
            '(The status check means that the host program determines if HPC kernel is running and if so,', ...
            'what the current iteration number is.)', ...
            'The status will be checked once per <i>%c4sPeriodSec</i> seconds.'};
    AddPosRatScalar('c4sPeriodSec', 5, 's', desc, 'backgroundMode');
    
    desc = {'How often HPC kernel should check for a command from Matlab host?', ...
            '(There are two commands: terminate, dump snapshot.)', ...
            'The check will be done once per <i>%c4cPeriodIter</i> iterations.'};
    AddIterCounter('c4cPeriod', 100, desc);
    
    desc = {'How often Matlab host should check if HPC kernel has executed requested command?', ...
            '(There are two commands: terminate, dump snapshot.)', ...
            'The check will be done once per <i>%c4ePeriodSec</i> seconds.'};
    AddPosRatScalar('c4ePeriodSec', 5, 's', desc);
    
    AddStringScalar('outFileName', '''output''', 'Output MAT-file name', true, 'valPred_outFileName(outFileName)', '.mat');
    
    AddBoolScalar('saveInput2Output', true, 'Whether to save input parameters to output MAT-file');
    
    desc = {'The limit for number of spikes per one simulation session.', ...
            'It will be used to preallocate the following arrays in HPC kernel: idx_e_spikes, t_e_spikes and other.', ...
            'The limit for number of spikes of a type is computed in HPC kernel as:', ...
            'max_num_spikes_e = int32(%num_e * %m_steps * %max_num_spikes_e_factor);'};
    AddPosRatScalar('max_num_spikes_e_factor', 0.02, '', desc);
    
    desc = {'The limit for number of spikes per one simulation session.', ...
            'It will be used to preallocate the following arrays in HPC kernel: idx_i_spikes, t_i_spikes and other.', ...
            'The limit for number of spikes of a type is computed in HPC kernel as:', ...
            'max_num_spikes_i = int32(%num_i * %m_steps * %max_num_spikes_i_factor);'};
    AddPosRatScalar('max_num_spikes_i_factor', 0.02, '', desc);
    
end