function AddInitCondParams()
%% Initial conditions for ODEs

    AddPanel('Initial Conditions');
    
    AddRatVector('v_e', '-70 + rand(num_e, 1) * 3', 'mV', 'Voltage of pyramidal neuron', true, 'length(v_e) == num_e');
    AddRatVector('s_e', 'zeros(num_e, 1)', '', 'Kinetics constant', true, 'length(s_e) == num_e');
    
    AddRatVector('v_i', '-70 + rand(num_i, 1) * 3', 'mV', 'Voltage of Interneurons', true, 'length(v_i) == num_i');
    AddRatVector('s_i', 'zeros(num_i, 1)', '', 'Kinetics constant', true, 'length(s_i) == num_i');
    
    AddRatVector('s_stoch_e', 'zeros(num_e, 1)', '', 'Parameter of synaptic activation of pyramidal neurons', true, 'length(s_stoch_e) == num_e');
    AddRatVector('s_stoch_i', 'zeros(num_i, 1)', '', 'Parameter of synaptic activation of inter neurons', true, 'length(s_stoch_i) == num_i');
    
end