function AddModelAstroParams()
%% Add astrocyte network parameters

    global Astro2PyraBindings
    
    AddPanel('Model (Astro)');

    AddBoolScalar('enableAstro', false, 'Whether to enable the astrocyte network');
    
    relPred = 'enableAstro';
    
    AddPosRatScalar('astroTimeScale', 1000, '', 'Astrocytes evolution time scale divisor', relPred);
    
    desc = 'The type of binding of astrocytes to pyramidal cells';
    descItemPat = 'Astrocytes are bound to %s-cells and affect %s->%s release probability';
    descItems = {sprintf(descItemPat, 'e', 'e', 'e'), ...
                 sprintf(descItemPat, 'e', 'e', 'i'), ...
                 sprintf(descItemPat, 'i', 'i', 'e'), ...
                 sprintf(descItemPat, 'i', 'i', 'i')};
    AddList('astro2PyraBinding', fieldnames(Astro2PyraBindings), Astro2PyraBindings.EI, desc, descItems, relPred);
    
    AddRatScalar('v1', 6, 'mV', 'Parameter of astrocyte network', relPred);
    AddRatScalar('v2', 0.11, 'mV', 'Parameter of astrocyte network', relPred);
    AddRatScalar('v3', 0.9, 'mV', 'Parameter of astrocyte network', relPred);
    
    AddRatScalar('d1', 0.13, 'M', 'Parameter of astrocyte network', relPred);
    AddRatScalar('d2', 1.049, 'M', 'Parameter of astrocyte network', relPred);
    AddRatScalar('d3', 0.9434, 'M', 'Parameter of astrocyte network', relPred);
    AddRatScalar('d5', 0.08234, 'M', 'Parameter of astrocyte network', relPred);
    
    AddRatScalar('c1', 0.185, '', 'Parameter of astrocyte network', relPred);
    AddRatScalar('a2', 0.2, '1 / M / s', 'Parameter of astrocyte network', relPred);
    AddRatScalar('k3', 0.1, 'M', 'Parameter of astrocyte network', relPred);
    AddRatScalar('ip3star', 0.16, 'mM', 'IP3 basic concnetration', relPred);
    AddRatScalar('tip3', 7, 'ms', 'IP3 time constant', relPred);
    AddRatScalar('rip3', 7.2, '1 / ms', 'Parameter of astrocyte network', relPred);
    
    AddRatScalar('gs', 1, 'mS', 'Parameter of astrocyte network', relPred);
    
    AddRatScalar('tau_spike', 2, 'ms', 'Parameter of astrocyte network', relPred);
    AddRatScalar('t_in', 200, 'ms', 'Parameter of astrocyte network', relPred);
    
    AddNonNegRatScalar('p_basic', 0.2, '', 'Minimum release probability', relPred, 'p_basic <= 1');
    AddNonNegRatScalar('CaBA', 0.2, 'mM', 'Resting Ca concentration', relPred);
    AddNonNegRatScalar('CaRateRelease', '4 / 29', '1 / mM', 'Derivative of release probability by Ca concentration', relPred);
    
    AddRatScalar('Ca_ER', 5, 'M', 'Ca_ER concnetration', relPred);
    
end
    