function AddModelParams_for_UTILITY_ComputeMaxModelSize()

    global SclModels
    
    AddPanel('Model');
    
    AddPosRatScalar('t_final', 1000, 'ms', 'Time simulated');
    AddPosRatScalar('dt', 0.02, 'ms', 'Time step used in the midpoint method');
    
    desc = {'Width of time window used for calculation of spikes frequencies in the following two cases:', ...
        '1) calculation of overall i-network frequency if %dynamicGTonicGABA is checked;', ...
        '2) calculation of particular neurons frequencies if %enableSTDP is checked.'};
    AddPosRatScalar('freqWinWidth', '5000 * dt', 'ms', desc, true, 'round(freqWinWidth / dt) > 0');
    
    descItems = {'bell-shaped strength and uniform density of connections', ...
                 'uniform strength and bell-shaped density of connections'};
    AddList('sclModel', fieldnames(SclModels), SclModels.BSD, 'Synaptic connections localization model', descItems);
    
    desc = {'Maximum strengths of synaptic connections', ...
            '(the density of synaptic connections is highest possible)'};
    relPred = 'sclModel == SclModels.BSS';
    AddRatScalar('w_ee_max_bss', 1.3, '', desc, relPred);
    AddRatScalar('w_ii_max_bss', 0.35, '', desc, relPred);
    AddRatScalar('w_ei_max_bss', 0.5, '', desc, relPred);
    AddRatScalar('w_ie_max_bss', 0.15, '', desc, relPred);
    
    desc = {'Maximum densities of synaptic connections.', ...
            'Notice that:', ...
            '1) the value > 1 gives saturation and corresponds to value = 1;', ...
            '2) the strengths of the connections are given by %g_hat_ee, %g_hat_ii, %g_hat_ei and %g_hat_ie.'};
    relPred = 'sclModel == SclModels.BSD';
    AddRatScalar('w_ee_max_bsd', 2, '', desc, relPred);
    AddRatScalar('w_ii_max_bsd', 0.8, '', desc, relPred);
    AddRatScalar('w_ei_max_bsd', 0.9, '', desc, relPred);
    AddRatScalar('w_ie_max_bsd', 0.3, '', desc, relPred);
    
    desc = 'Strength of synaptic connections';
    AddRatScalar('g_hat_ie', 'SynWeight * 0.96', 'mS / cm2', desc);
    AddRatScalar('g_hat_ei', 'SynWeight * 0.80 * 5', 'mS / cm2', desc);
    AddRatScalar('g_hat_ii', 'SynWeight', 'mS / cm2', desc);
    AddRatScalar('g_hat_ee', '0.025 * SynWeight', 'mS / cm2', desc);
    
    %% Parameters of circular networks
    AddPosRatScalar('radius_e', 250, 'm', 'Radius of e-network');
    AddPosRatScalar('radius_i', 200, 'm', 'Radius of i-network');
    AddPosRatScalar('v', 0.1, 'm / ms', 'Rate of signal propagation');
    
    AddPosRatScalar('sigmaDivisor_ee', 10, 'm', 'Spatial variability of ee synapses');
    AddPosRatScalar('sigmaDivisor_ei', 12.5, 'm', 'Spatial variability of ei synapses');
    AddPosRatScalar('sigmaDivisor_ie', 8, 'm', 'Spatial variability of ie synapses');
    AddPosRatScalar('sigmaDivisor_ii', 11, 'm', 'Spatial variability of ii synapses');
    
end