function AddModelStdpParams_for_UTILITY_PlotStdpModels()
%% Add STDP-related parameters
    
    global HostDirTypes
    global enableSTDP
    
    AddPanel('Model (STDP)');
    
    enableSTDP = true;
    
    AddIterCounter('stdpPeriod', 1000, 'How often Hebbian correction is done (in iterations)');

    AddBoolScalar('windowedSTDP', false, 'Whether smooth window (Epsilon) is applied in the analyzed STDP interval');
    
    AddPosRatScalar('epsAt0p5T', 0.9, '', 'The value of the Epsilon function at the point of 0.5 * %stdpPeriodIter * %dt', 'windowedSTDP', 'epsAt0p5T < 1');
    
    AddBoolScalar('importSTDP', false, 'Whether STDP models are imported from text files');
    
    stdpParams = [ ...
%       ee     ei     ie     ii
        0      0      0      0      ;   % Aplus
        1      1      1      3      ;   % S
        0      0      0      0.012  ;   % epsilon
        0      0      1      0      ;   % Aminus
        20     20     20     20     ;   % tau2, ms^-1
        12     12     12     12     ;   % S2
        0      0      0.2    0      ;   % AC
        0.3    0.3   -0.05   0.3    ;   % TimeCosExp
        0.3    0.3   -0.05   0.3    ;   % TimeCos
       -0.1    0.1    0      0      ;   % AS
       -0.2   -0.2   -0.2   -0.2    ;   % TimeSinExp
        0.05   0.05   0.05   0.05   ;   % TimeAbs
        5      5      5      5      ;   % Shift
        10000  10000  10000  10000  ;   % SinAmpl
        0.001  0.001  0.001  0.001  ;   % SinPeriod
        100    100    100    100    ;   % damper
        0.01   0.01   0.01   0.01  ];   % maxAbsdW
    rowNames = {'Aplus', 'S', 'epsilon', 'Aminus', 'tau2, [ms^-1]', 'S2', 'AC', 'TimeCosExp', 'TimeCos', 'AS', 'TimeSinExp', 'TimeAbs', 'Shift', 'SinAmpl', 'SinPeriod', 'damper', 'maxAbsdW'};
    colNames = {'ee', 'ei', 'ie', 'ii'};
    desc = 'Parameters of spike-timing-dependant plasticity (Hebbian correction) for each matrix of synaptic conductance';
    AddFixedSizeMatrix('stdpParams', stdpParams, rowNames, colNames, desc, '~importSTDP', 'valPred_stdpParams(stdpParams)');
    
    % Add four stdpFile_** parameters
    suffixes = {'ee', 'ei', 'ie', 'ii'};
    namePat = 'stdpFile_%s';
    valuePat = '''stdpModel_%s.txt''';
    descPat = ['The file to import a tabulated STDP model from (<b>%s</b>-interaction).<br><br>', ...
               'You can specify a file name, a relative file path or an absolute file path.<br>', ...
               'In the first two cases, the next base directory will be used:<br>', ...
               '<b>', strrep(GetDirPath(HostDirTypes.IO), '\', '\\'), '</b><br>', ...
               'If the file name or path contains single quote characters (''), each of them should be doubled ('''').<br><br>', ...
               'The file should contain two data columns: the time samples (in milliseconds) and the factors (unitless).<br>', ...
               'The time samples should go equidistantly ascending.<br>', ...
               'The low-level file format should be conformant with this ASCII-delimited numeric data reader:<br>', ...
               '<a href="https://www.mathworks.com/help/matlab/ref/dlmread.html">https://www.mathworks.com/help/matlab/ref/dlmread.html</a>'];
    relPred = 'importSTDP';
    valPredPat = 'valPred_stdpFile(stdpFile_%s)';
    for i = 1 : length(suffixes)
        suffix = suffixes{i};
        name = sprintf(namePat, suffix);
        value = sprintf(valuePat, suffix);
        desc = sprintf(descPat, suffix);
        valPred = sprintf(valPredPat, suffix);
        AddStringScalar(name, value, desc, relPred, valPred);
    end
    
end
