function [hc, xPos] = CreateParamNameText(name)
%% Create a text label with the parameter name

    global layout
    
    bgColor = GetBackgroundColor(name);
    xPos = layout.xMargin0 + layout.rgWidth + layout.xMargin1;
    name = [name, ': '];
    hc = uicontrol('Style', 'text', ...
                   'Units', 'pixels', ...
                   'HorizontalAlignment', 'right', ...
                   'Position', [xPos, 0, layout.nameWidth, layout.ebHeight], ...
                   'BackgroundColor', bgColor, ...
                   'String', name);
        
    xPos = xPos + layout.nameWidth;
    
end

function bgColor = GetBackgroundColor(name)
%% Get the background color for the text label based on the parameter class (e, i, ee, ei, ie, ii)

    global palette
    
    if length(name) == 1
        bgColor = palette.backgroundColor;
    else
        if CheckParamClass(name, 'e')
            bgColor = palette.backgroundColor_EParams;
        elseif CheckParamClass(name, 'i')
            bgColor = palette.backgroundColor_IParams;
        elseif CheckParamClass(name, 'ee', 'ei', 'ie', 'ii')
            bgColor = palette.backgroundColor_XParams;
        else
            bgColor = palette.backgroundColor;
        end
    end
    
end

function tf = CheckParamClass(name, varargin)
%% Check if the given parameter has specific pattern(s) in its name

    for i = 1 : length(varargin)
        marker = varargin{i};
        endPat = ['_', marker];
        midPat = [endPat, '_'];
        if contains(name, midPat) || endsWith(name, endPat)
            tf = true;
            return
        end
    end
    tf = false;
    
end
