function isDeleted = ExposeSecFigAccDelete()
%% Expose the secondary figure for Account\Delete

    hf = CreateFigure('Delete account', 4);
    
    AddLabel(hf, 'Delete your Arachne account', true);
    h1 = AddButton(hf, 'Send Token', @SendTokenPushedFcn);   % !! these two fields are the same as for "Register" - maybe move them to a new foo
    h2 = AddEditField(hf, 'Token');
    h3 = AddButton(hf, 'Confirm Deletion', @ConfirmDeletionPushedFcn);
    
    set(h2, 'Enable', 'off');
    set(h3, 'Enable', 'off', ...
            'BackgroundColor', [1, 0.75, 0.75]); % !! move to palette
    
    isDeleted = false;
    
    uiwait(hf);
    
    function SendTokenPushedFcn(app, event)

        success = SerReqAccDeleteSendToken();
        ShowConfirmationTokenMessage(success);
        if ~success
            return
        end
        
        set(h1, 'Enable', 'off');
        set(h2, 'Enable', 'on');
        set(h3, 'Enable', 'on');
    end
    
    function ConfirmDeletionPushedFcn(app, event)
        
        data = {{@ValPredToken, h2}};
        success = PreValidateFields(data);
        if ~success
            return
        end
        
        token = get(h2, 'String');
        
        % !! Request to manager here
        isDeleted = SerReqAccDeleteConfirm(token);
        
        if isDeleted
            ShowInfoMessage('The account was deleted successfully', 'Deletion success'); % !! use the error message style in the case of error
        else
            ShowInfoMessage('The account was not deleted.', 'Deletion failure', true);	% !!
            return
        end
        
        close(hf);
    end
    
end
