function allValid = PreValidateFields(data)
%% !! actually it does not validate edit fields

    global palette
    
    n = length(data);
    msgs = cell(0, 1);
    allValid = true;
    for i = 1 : n
        datum = data{i};
        valPred = datum{1};
        handles = datum(2 : end);
        n = length(handles);
        assert(n == 1 || n == 2);   % Dev. assert (2 for Password & Confirm Password, 1 otherwise)
        
        % Extract strings from handles
        strings = cell(size(handles));
        for j = 1 : n
            h = handles{j}(end);
            switch class(h)
                case 'matlab.ui.control.UIControl'
                    % This is a simple edit field
                    assert(length(handles{j}) == 1);    % Dev. assert
                    isEmpty = get(h, 'UserData');
                    if ~isEmpty
                        strings{j} = get(h, 'String');
                    else
                        % We don't use get(h, 'String') here because it would return the default text
                        strings{j} = '';
                    end
                case 'matlab.ui.container.internal.JavaWrapper'
                    % This is a password edit field
                    assert(length(handles{j}) == 2);    % Dev. assert
                    strings{j} = h.JavaPeer.getText();
                otherwise
                    assert(false);  % Dev. assert
            end
        end
        
        [valid, name] = valPred(strings{:});
        
        if ~valid
            msgs{end + 1, 1} = ['* ', name];    %#ok<AGROW>
            allValid = false;
            lastHandle = handles{end};
            switch class(lastHandle(end))
                case 'matlab.ui.control.UIControl'
                    % This is a simple edit field
                    assert(length(lastHandle) == 1);    % Dev. assert
                    set(lastHandle, 'BackgroundColor', palette.invalidColor);
                case 'matlab.ui.container.internal.JavaWrapper'
                    % This is a password edit field
                    assert(length(lastHandle) == 2);    % Dev. assert
                    password = lastHandle(2).JavaPeer.getText();
                    if ~password.isEmpty()
                        jInvalidColor = java.awt.Color(1, 0.5, 0.5); % !! move it to palette?
                        lastHandle(2).JavaPeer.setBackground(jInvalidColor);
                    else
                    	set(lastHandle(1), 'BackgroundColor', palette.invalidColor);
                    end
                otherwise
                    assert(false);  % Dev. assert
            end
        end
    end
    
    if ~allValid
        % !! Small code dupl. with CallWithErrorHandlingPolicy
        msg = ['The following fields are not valid:'; msgs(:)];
        h = warndlg(msg, 'Invalid input', 'modal');
        beep();
        uiwait(h);
    end
    
end
