function [valid, hint] = ValPredLogin(login)
%% Validation predicate for "Login" field
    
    % !!
	minLength = 4;
    maxLength = 16;
    
    name = 'Login';
    
    len = length(login);
    valid = (len >= minLength && len <= maxLength); %!!
    if ~valid
        hint = sprintf('%s (must be of length %i to %i)', name, minLength, maxLength);
        return
    end
    
    valid = ~contains(login, '@');
    if ~valid
        hint = sprintf('%s (must not contain @ character)', name);
        return
    end
    
    hint = '';
    
end
