function [valid, hint] = ValPredLoginOrEmail(loginOrEmail)
%% Validation predicate for "Login or Email" field
    
    % It's guaranteed that loginOrEmail cannot be a valid login and email at the same time
    % because we disallow usage of @ character in login
    valid = ValPredLogin(loginOrEmail) || ValPredEmail(loginOrEmail);
    if ~valid
        hint = 'Login or Email';
        return
    end
    
    hint = '';
    
end
