function [valid, hint] = ValPredPassword(password)
%% Validation predicate for "Password" field
    
    assert(isa(password, 'java.lang.String'));
    
    % !!
	minLength = 4;
    maxLength = 16;
    minNumUniqueChars = 3;
    
    name = 'Password';
    
    len = length(password);
    valid = (len >= minLength && len <= maxLength); %!!
    if ~valid
        hint = sprintf('%s (must be of length %i to %i)', name, minLength, maxLength);
        return
    end
    
    % !! maybe remove this validation condition
    valid = (length(unique(char(password))) >= minNumUniqueChars); % !!
    if ~valid
        hint = sprintf('%s (must have %i unique characters at least)', name, minNumUniqueChars);
        return
    end
    
    hint = '';
    
end
