function SCRIPT_TerminateBackgroundProcess()
%% Request termination of HPC kernel process running in background mode.
%  (This entry point is for both desktop and mobile versions of Matlab.)

    % !! clean global vars
    
    clc;
    
    AddPaths();
    
    BasicParams();

    foo = @SCRIPT_Core;
    CallWithErrorHandlingPolicy(foo, 'Error', true);
    
end

function SCRIPT_Core()
%%

    global c4ePeriodSec
    global mainScenarioMsg
    
    % How often the host should check if the kernel has executed the requested command (in seconds)
    c4ePeriodSec = 5;
    
    % Make sure that the kernel is running at the moment
    isRunning = CheckIfRunning();
    if ~isRunning
        % !! pause in compiled mode
        disp('HPC kernel process is not active -- nothing to terminate.');
        return
    end

    command = ScriptCallCommand('send_command');

    disp('Asking HPC kernel for dumping the current progress and termination ...');
    status = system([command, ' terminate']);
    if status ~= 0
        error('Failed to do the request.');
    end
    disp('Request submitted.');

    while true
        
        % Wait
        pause(c4ePeriodSec);

        % Check if HPC kernel process is alive
        isRunning = CheckIfRunning(true);
        if ~isRunning
            disp('HPC kernel has terminated.');
            fprintf('Now you can %s to grab simulation results or continue simulation from the same point (if checkbox "saveIntermMat" was checked).\n', mainScenarioMsg);
            break
        else
            disp('HPC kernel has not terminated yet ...');
        end
    end
    
    % !! pause in compiled mode
    
end