function GenerateCumulativeSrcFile(modClassNames_e, modClassNames_i, outDirPath)

    outFileName = 'AllModCurrents.cpp';
    
    fprintf('    Generating %s ...\n', outFileName);
    
    numModClasses_e = length(modClassNames_e);
    numModClasses_i = length(modClassNames_i);
    
    lines = {'#include "AllModCurrents.h"'; ''};
    for i = 1 : numModClasses_e
        lines{end + 1} = sprintf('#include "%s.cpp"', modClassNames_e{i}); %#ok<AGROW>
    end
    lines{end + 1} = '';
    for i = 1 : numModClasses_i
        lines{end + 1} = sprintf('#include "%s.cpp"', modClassNames_i{i}); %#ok<AGROW>
    end
    lines{end + 1} = '';
    lines{end + 1} = 'template';
    lines{end + 1} = 'class AllModCurrents_e<float>;';
    lines{end + 1} = '';
    lines{end + 1} = 'template';
    lines{end + 1} = 'class AllModCurrents_e<double>;';
    
    lines{end + 1} = '';
    
    lines{end + 1} = 'template';
    lines{end + 1} = 'class AllModCurrents_i<float>;';
    lines{end + 1} = '';
    lines{end + 1} = 'template';
    lines{end + 1} = 'class AllModCurrents_i<double>;';
    
    SaveLinesToFile(lines, outDirPath, outFileName);
     
end
